New-UDPage -Name 'Theme' -Icon (New-UDIcon -Icon 'Paintbrush') -Content {

    New-UDComponentDemo -Title 'Color' -Description 'Update the color pallet using a theme hashtable.' -Content {
        New-UDButton -Text "Set Theme " -OnClick {
            $Theme = @{
                palette = @{
                    primary   = @{
                        light = '#e9c46a'
                        main  = '#2a9d8f'
                        dark  = '#264653'
                    }
                    secondary = @{
                        light = '#e9c46a'
                        main  = '#f4a261'
                        dark  = '#e76f51'
                    }
                }
            }
            Set-UDTheme -Theme $Theme
        }
    }

    New-UDComponentDemo -Title 'Dark and Light Themes' -Description 'Specify a dark and light palette to support both color modes.' -Content {
        New-UDButton -Text "Set Theme " -OnClick {
            $Theme = @{
                light = @{
                    palette = @{
                        primary = @{
                            main = "#fff"
                        }
                    }
                }
                dark  = @{
                    palette = @{
                        primary = @{
                            main = "#333"
                        }
                    }
                }
            }
            Set-UDTheme -Theme $Theme
        }
    }

    New-UDComponentDemo -Title 'Font Size' -Description 'Adjust font size with the typography settings.' -Content {
        New-UDButton -Text "Set Theme " -OnClick {
            $Theme = @{
                typography = @{
                    fontSize = 20
                }
            }
            Set-UDTheme -Theme $Theme
        }
    }

    New-UDComponentDemo -Title 'Component Overrides' -Description 'Override specific component styles.' -Content {
        New-UDButton -Text "Set Theme " -OnClick {
            $Theme = @{
                overrides = @{
                    MuiButton = @{
                        root  = @{
                            padding = 20
                        }
                        label = @{
                            fontSize = 40
                        }
                    }
                }
            }
            Set-UDTheme -Theme $Theme
        }
    }

    New-UDComponentDemo -Title 'Reset Theme' -Description 'Reset the theme back to default.' -Content {
        New-UDButton -Text "Reset " -OnClick {
            Reset-UDTheme
        }
    }
}