New-UDPage -Name 'PowerShell Host' -Icon (New-UDIcon -Icon 'Server') -Content {

    New-UDComponentDemo -Title 'Read-Host' -Description 'Use Read-Host to retrieve data from the user.' -Content {
        New-UDButton -Text 'Read-Host' -OnClick {
            $Name = Read-Host 'What is your name?'
            Show-UDToast -Message "Hello $Name"
        }
    }

    New-UDComponentDemo -Title 'Write-Progress' -Description 'Use Write-Progress to show a progress bar to the user.' -Content {
        New-UDButton -Text 'Write-Progress' -OnClick {
            Write-Progress -Activity 'Loading' -Status 'Loading data' -PercentComplete 0
            for ($i = 0; $i -lt 100; $i++) {
                Write-Progress -Activity 'Loading' -Status 'Loading data' -PercentComplete $i
                Start-Sleep -Milliseconds 100
            }
            Write-Progress -Activity 'Loading' -Status 'Loading data' -Completed
        }
    }

    New-UDComponentDemo -Title 'PromptForChoice' -Description 'Use PromptForChoice to show a list of options to the user.' -Content {
        New-UDButton -Text 'PromptForChoice' -OnClick {
            $Title = "Welcome"
            $Info = "Just to Demo Prompt for Choice"
            
            $options = [System.Management.Automation.Host.ChoiceDescription[]] @("Power", "Shell", "Quit")
            [int]$defaultchoice = 2
            $opt = $host.UI.PromptForChoice($Title , $Info , $Options, $defaultchoice)
            switch ($opt) {
                0 { Show-UDToast "Power" }
                1 { Show-UDToast "Shell" }
                2 { Show-UDToast "Good Bye!!!" }
            }
        }
    }

    New-UDComponentDemo -Title "Get-Credential" -Description "Use Get-Credential to get a username and password from the user." -Content {
        New-UDButton -Text "Get-Credential" -OnClick {
            $Credential = Get-Credential
            Show-UDToast -Message "Username: $($Credential.UserName) Password: $($Credential.GetNetworkCredential().Password)"
        }
    }

    New-UDComponentDemo -Title 'Write-Host' -Description "Write log messages with Write-Host. View the logs on the dashboard page or by pressing F12 in the browser and navigating to the console tab" -Content {
        New-UDButton -Text 'Write-Host' -OnClick {
            Write-Host "This is a log message"
        }
    }
}
